#include <stdio.h>

#define MXVERTS 20
int ingon[MXVERTS][2],outgon[MXVERTS][2];
int invnum,outvnum;	/* number vertices in ingon, outgon */
int inidx, outidx;	/* index of current vertex */
int oc1,oc2;		/* outcodes of endpoints of current vertex */

int	xleft, xright, ybottom, ytop;

main()
{
	int i,vc;
	int x,y,x2,y2;	/* current vertex */
	int dx,dy;	/* dist to next vertex */
	int xin, xout, yin, yout;
	int tx, ty;		
	tapint();
	sif('M');
	ods(1);
	stp(2);etp(1);dca(0,0);
	getwindow();
	invnum = getverts(); /* get vertex list in ingon */
	etp(0);
	sec(4);
	pgon(invnum,ingon);
	
/*
 * main loop, process edge ingon[i], ingon[i+1]
 */

outidx = 0;
for(i=0;i<invnum;i++){

	x = ingon[i][0];		
	y = ingon[i][1];		

	x2 = ingon[i+1][0];
	y2 = ingon[i+1][1];

	dx = x2 - x;
	dy = y2 - y;

	printf("edge #%d(%d %d)(%d %d)\t",i,
		x,y,x2,y2);
	oc1 = outcode(x,y);
	oc2 = outcode(x2,y2);


	if((oc1|oc2) == 0){	/* test for trivial accept */
		outv(0,x2,y2);
		continue;
	}
	if(oc1 == oc2){		/* same outcode, trivial reject */
		printf("reject =\n");
		continue;
	}

/*
 * This edge may intersect the window.
 * In any case, this edge contributes to the 
 * output polygon, unless it just goes from a
 * side region to an adjacent corner.
 */

	if(corner(oc1))	/* exiting corner, output window corner */
		switch(oc1){
		case 5 : outv(oc1,xleft,ybottom);break;
		case 6 : outv(oc1,xright,ybottom);break;
		case 9 : outv(oc1,xleft,ytop);break;
		case 10: outv(oc1,xright,ytop);break;
		}


	if(oc1&oc2){	/* unless intersection possible, we're done */
		printf("reject and\n");
		continue;
	}

	if(!oc1){	/* xy inside, output intersection */
		clipl(&x,&y,&x2,&y2);
		outv(100,x2,y2);
		continue;
	}
	if(!oc2){
		clipl(&x,&y,&x2,&y2);
		outv(101,x,y);		
		outv(102,x2,y2);
		continue;
	}


	tx = x;ty = y;
	if(clipl(&tx,&ty,&x2,&y2)){
		outv(103,tx,ty);
		outv(104,x2,y2);
		continue;
	}
/*
 * no intersection.  output turning vertex.
 */

	if((oc1|oc2) == 15){ /* opposite corners */
		printf("hard one\n");
/*		
		if(oc1&1){
			xin = xleft; xout = xright;
		}else{
		 	xin = xright; xout = xleft;
		}
		if(oc1&4){
			yin = ybottom; yout = ytop;
		}else{
		 	yin = ytop; yout = ybottom;
		}
*/
/*
 * next we want to compare
 * (xin-x)/dx and (yin-y)/dy, but the imprecise nature
 * of integer divide necessitates a more roundabout approach.
 * The one chosen here is to multiply both expressions by
 * (dx*dy).  Note that if we are going from upper left to
 * lower right, dy and dx are of opposite sign, reversing the
 * sense of the original comparison.  On second thought, it
 * seems easier to special case each original corner.
 */
		if( ((xin-x)/dx) > ((yin-y)/dy) ){
			outv(300,xin,yout);
			continue;
		}else{
			outv(301,xout,yin);
			continue;
		}
	}
*/



	vc = tv(oc1,oc2); /* get outcode of turning vertex */
	switch(vc){			
		case 5 : outv(oc1,xleft,ybottom);break;
		case 6 : outv(oc1,xright,ybottom);break;
		case 9 : outv(oc1,xleft,ytop);break;
		case 10: outv(oc1,xright,ytop);break;
	}


} /* end of edge */

	sec(2);
	pgon(outidx,outgon);

}

pgon(n,verts)
int n;
int (*verts)[2];
{
	int i,x,y;
	printf("%d edges\n",n);
	mov(x = (*verts)[0],y = (*verts)[1]);
	verts++;
	for(i=1;i<n;i++){
		dva((*verts)[0],(*verts)[1]);
		verts++;
	}
	dva(x,y);

}
		

outv(c,x,y)		/* add vertex to output array */
int c;
int x,y;
{
	if(outidx > MXVERTS){
		printf("too much output\n");
		exit(1);
	}
	outgon[outidx][0] = x;
	outgon[outidx][1] = y;

	printf("case %d %d %d\n",c, outgon[outidx][0],
			  outgon[outidx][1]);
	outidx++;
}

getwindow()
{
	int x0,y0,x1,y1;
	int ff = 0xff;

	printf("enter window x0 y0 x1 y1\n");
	scanf("%d %d %d %d",&x0,&y0,&x1,&y1);
	xleft = x0;
	ybottom = y0;
	xright = x1;
	ytop = y1;

	mov(x0,y0);
	sec(8);
	sct(8,1,&ff,&ff,&ff);
	dra(x1,y1);


}


getverts()
{

	while(pick(inidx))
		inidx++;
	ingon[inidx][0] = ingon[0][0];
	ingon[inidx][1] = ingon[0][1];
	
	return(inidx);
}

pick(i)
int i;
{
	int id,x,y,stat;
	char buf[4];
	stat = 0;
	do
		rtp(&id,&stat,&x,&y);
	while(!(stat&15));

	if(x > 100){
		mov(x,y);
		sprintf(buf,"%d",i);
		txt(buf,0);
		ingon[i][0] = x;
		ingon[i][1] = y;
	}
	while(stat)
		rtp(&id,&stat,&id,&id);
	return(x>100);
}

outcode(x,y)
int x,y;
{
	int i = 0;

	if(x < xleft)
		i = 1;
	else if (x > xright)
		i = 2;
	if(y < ybottom)
		i |= 4;
	else if (y > ytop)
		i |= 8;

	return(i);
}

/* octype[c] = 1 if c is a side outcode, 2 for corner outcode */

char octype[] = {0,1,1,0,1,2,2,0,1,2,2};

side(c)		/* return true if outcode c is a side region */
int c;
{
	return(octype[c]&1);
}

corner(c)	/* return true if outcode c is a corner region */
int c;
{
	return(octype[c]&2);
}

char tvoc[] = {	16*1+4,16*1+6,16*4+9, /* corner 5 */
		16*2+4,16*2+5,16*4+10, /* corner 6 */
		16*1+8,16*1+10,16*5+8, /* corner 9 */
		16*2+8,16*2+9,16*6+8}; /* corner 10 */

char tvmap[] = {5,6,9,10};

tv(c1,c2)	/* return outcode of corner for c1, c2 */
int c1,c2;
{
	int i,j;
	j = (c1<c2) ? c1*16+c2 : c2*16+c1;
	for(i=0;i<sizeof(tvoc);i++)
		if(j == tvoc[i])
			return(tvmap[i/3]);
	return(0);
}

	
ods(c)
int c;
{
	obyte("+@",2);
	obyte(&c,1);
}

#define TOLEFT 1
#define TORIGHT 2
#define TOTOP 	8
#define TOBOTTOM 4


clipl(x1,y1,x2,y2)	/* return  0 for trivial reject, */
int *x1,*y1,*x2,*y2;	/* else clip xy to wp and return <>0 */
{
	int c1, c2, vc;
	long dx, dy;


	for(;;){
		c1 = outcode(*x1,*y1);
		c2 = outcode(*x2,*y2);
	
		if(c1 & c2)			/* trivial reject */
			return(0);
		if( (c1 | c2) == 0)		/* trivial accept */
			return(1);
	
		dx = *x2 - *x1;
		dy = *y2 - *y1;
	
		if(c1&1){ /* if x1y1 is left of window */
			*y1 += (dy*(xleft-*x1)/dx);
			*x1 = xleft;
		}
		else if (c1&2){ /* right of window */
			*y1 += (dy*(xright-*x1)/dx);
			*x1 = xright;
		}
		else if(c1&4){ /* if below window */
			*x1 += (dx*(ybottom-*y1)/dy);
			*y1 = ybottom;	
		}
		else if(c1&8){ /* above window */
			*x1 += (dx*(ytop-*y1)/dy);
			*y1 = ytop;	
		}


		else if(c2&1){ /* if x2y2 is left of window */
			*y2+= (dy*(xleft-*x2)/dx);
			*x2 = xleft;
		}
		else if (c2&2){ /* right of window */
			*y2 += (dy*(xright-*x2)/dx);
			*x2 = xright;
		}
		else if(c2&4){ /* if below window */
			*x2 += (dx*(ybottom-*y2)/dy);
			*y2 = ybottom;	
		}
		else if(c2&8){ /* above window */
			*x2 += (dx*(ytop-*y2)/dy);
			*y2 = ytop;	
		}
	}
}

